#pragma GCC target ("avx2")
#pragma GCC optimization ("O3")
#pragma GCC optimization ("unroll-loops")

#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

typedef long long ll;

ll n, m;
vector<vector<ll>> from;
vector<ll> max_path_from_0;
vector<ll> used;
vector<bool> can_reach_0;
vector<ll> p;

void dfs1(ll ind, ll already) {
    used[ind] = 1;
    for (ll i = 0; i < from[ind].size(); i++) {
        if (used[from[ind][i]] == 2) {
            if (max_path_from_0[from[ind][i]] < already + 1)
                p[from[ind][i]] = ind;
            max_path_from_0[from[ind][i]] = max(max_path_from_0[from[ind][i]], already + 1);
        }
        else if (used[from[ind][i]] == 0) {
            if (max_path_from_0[from[ind][i]] < already + 1)
                p[from[ind][i]] = ind;
            max_path_from_0[from[ind][i]] = max(max_path_from_0[from[ind][i]], already + 1);
            dfs1(from[ind][i], max_path_from_0[from[ind][i]]);
        }
    }
    used[ind] = 2;
}
void dfs2(ll ind, ll already) {
    used[ind] = 1;
    for (ll i = from[ind].size()-1; i >= 0; i--) {
        if (used[from[ind][i]] == 2) {
            if (max_path_from_0[from[ind][i]] < already + 1)
                p[from[ind][i]] = ind;
            max_path_from_0[from[ind][i]] = max(max_path_from_0[from[ind][i]], already + 1);
        }
        else if (used[from[ind][i]] == 0) {
            if (max_path_from_0[from[ind][i]] < already + 1)
                p[from[ind][i]] = ind;
            max_path_from_0[from[ind][i]] = max(max_path_from_0[from[ind][i]], already + 1);
            dfs2(from[ind][i], max_path_from_0[from[ind][i]]);
        }
    }
    used[ind] = 2;
}

vector<ll> w;
void write(ll ind) {
    if (ind != -1) {
        w.push_back(ind);
        write(p[ind]);
    }
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    cin >> n >> m;
    from.resize(n);
    can_reach_0.resize(n);
    for (ll i = 0; i < m; i++) {
        ll v, u;
        cin >> v >> u; v--; u--;
        from[v].push_back(u);

        if (u == 0)
            can_reach_0[v] = true;
    }

    max_path_from_0.resize(n);
    used.resize(n);
    p.resize(n); p[0] = -1;
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs1(0, 1);

    for (ll i = 0; i < n; i++) {
        if (max_path_from_0[i] == n && can_reach_0[i]) {
            cout << "YES\n";
            write(i);
            for (ll i = 0; i < n; i++)
                cout << w[n-i-1] + 1 << ' ';
            cout << 1;
            return 0;
        }
    }
    cout << "NO";

    return 0;
}